require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_SYS_NODEMASK_H)) {
    eval 'sub _SYS_NODEMASK_H () {1;}' unless defined(&_SYS_NODEMASK_H);
    # "$Revision: 1.17 $"
    if(defined(&_KERNEL) || defined(&_STANDALONE) || defined(&_KMEMUSER)) {
	if(((defined(&SN0) ? &SN0 : undef))) {
	    require 'sys/SN/SN0/arch.ph';
	}
	if(((defined(&SN1) ? &SN1 : undef))) {
	    require 'sys/SN/SN1/arch.ph';
	}
	eval 'sub CNODEMASK_BOOTED_MASK () { &boot_cnodemask;}' unless defined(&CNODEMASK_BOOTED_MASK);
	eval 'sub CNODEMASK_BIPW () {64;}' unless defined(&CNODEMASK_BIPW);
	if(!defined(&SN0XXL)  && !defined(&SN1) ) {
	    eval 'sub CNODEMASK_SIZE () {1;}' unless defined(&CNODEMASK_SIZE);
	    eval 'sub CNODEMASK_WORD {
	        my($p,$w) = @_;
    		eval q(($p));
	    }' unless defined(&CNODEMASK_WORD);
	    eval 'sub CNODEMASK_SET_WORD {
	        my($p,$w,$val) = @_;
    		eval q(($p) = $val);
	    }' unless defined(&CNODEMASK_SET_WORD);
	    eval 'sub CNODEMASK_CLRALL {
	        my($p) = @_;
    		eval q(($p) = 0);
	    }' unless defined(&CNODEMASK_CLRALL);
	    eval 'sub CNODEMASK_SETALL {
	        my($p) = @_;
    		eval q(($p) = ~(( &cnodemask_t)0));
	    }' unless defined(&CNODEMASK_SETALL);
	    eval 'sub CNODEMASK_IS_ZERO {
	        my($p) = @_;
    		eval q((($p) == 0));
	    }' unless defined(&CNODEMASK_IS_ZERO);
	    eval 'sub CNODEMASK_IS_NONZERO {
	        my($p) = @_;
    		eval q((($p) != 0));
	    }' unless defined(&CNODEMASK_IS_NONZERO);
	    eval 'sub CNODEMASK_NOTEQ {
	        my($p, $q) = @_;
    		eval q((($p) != ($q)));
	    }' unless defined(&CNODEMASK_NOTEQ);
	    eval 'sub CNODEMASK_EQ {
	        my($p, $q) = @_;
    		eval q((($p) == ($q)));
	    }' unless defined(&CNODEMASK_EQ);
	    eval 'sub CNODEMASK_LSB_ISONE {
	        my($p) = @_;
    		eval q((($p) & 0x1));
	    }' unless defined(&CNODEMASK_LSB_ISONE);
	    eval 'sub CNODEMASK_ZERO () {
	        eval q((( &cnodemask_t)0));
	    }' unless defined(&CNODEMASK_ZERO);
	    eval 'sub CNODEMASK_CVTB {
	        my($bit) = @_;
    		eval q((1 << ($bit)));
	    }' unless defined(&CNODEMASK_CVTB);
	    eval 'sub CNODEMASK_SETB {
	        my($p, $bit) = @_;
    		eval q((($p) |= 1 << ($bit)));
	    }' unless defined(&CNODEMASK_SETB);
	    eval 'sub CNODEMASK_CLRB {
	        my($p, $bit) = @_;
    		eval q((($p) &= ~(1 << ($bit))));
	    }' unless defined(&CNODEMASK_CLRB);
	    eval 'sub CNODEMASK_TSTB {
	        my($p, $bit) = @_;
    		eval q((($p) & (1 << ($bit))));
	    }' unless defined(&CNODEMASK_TSTB);
	    eval 'sub CNODEMASK_SETM {
	        my($p, $q) = @_;
    		eval q((($p) |= ($q)));
	    }' unless defined(&CNODEMASK_SETM);
	    eval 'sub CNODEMASK_CLRM {
	        my($p, $q) = @_;
    		eval q((($p) &= ~($q)));
	    }' unless defined(&CNODEMASK_CLRM);
	    eval 'sub CNODEMASK_ANDM {
	        my($p, $q) = @_;
    		eval q((($p) &= ($q)));
	    }' unless defined(&CNODEMASK_ANDM);
	    eval 'sub CNODEMASK_TSTM {
	        my($p, $q) = @_;
    		eval q((($p) & ($q)));
	    }' unless defined(&CNODEMASK_TSTM);
	    eval 'sub CNODEMASK_CPYNOTM {
	        my($p, $q) = @_;
    		eval q((($p) = ~($q)));
	    }' unless defined(&CNODEMASK_CPYNOTM);
	    eval 'sub CNODEMASK_CPY {
	        my($p, $q) = @_;
    		eval q((($p) = ($q)));
	    }' unless defined(&CNODEMASK_CPY);
	    eval 'sub CNODEMASK_ORNOTM {
	        my($p, $q) = @_;
    		eval q((($p) |= ~($q)));
	    }' unless defined(&CNODEMASK_ORNOTM);
	    eval 'sub CNODEMASK_SHIFTL {
	        my($p) = @_;
    		eval q((($p) <<= 1));
	    }' unless defined(&CNODEMASK_SHIFTL);
	    eval 'sub CNODEMASK_SHIFTR {
	        my($p) = @_;
    		eval q((($p) >>= 1));
	    }' unless defined(&CNODEMASK_SHIFTR);
	    eval 'sub CNODEMASK_SHIFTL_PTR {
	        my($p) = @_;
    		eval q((*($p) <<= 1));
	    }' unless defined(&CNODEMASK_SHIFTL_PTR);
	    eval 'sub CNODEMASK_SHIFTR_PTR {
	        my($p) = @_;
    		eval q((*($p) >>= 1));
	    }' unless defined(&CNODEMASK_SHIFTR_PTR);
	    eval 'sub CNODEMASK_ATOMSET_BIT {
	        my($p, $bit) = @_;
    		eval q( &atomicSetUlong(( &cnodemask_t *)($p), (1<<($bit))));
	    }' unless defined(&CNODEMASK_ATOMSET_BIT);
	    eval 'sub CNODEMASK_ATOMCLR_BIT {
	        my($p, $bit) = @_;
    		eval q( &atomicClearUlong(( &cnodemask_t *)($p), (1<<($bit))));
	    }' unless defined(&CNODEMASK_ATOMCLR_BIT);
	    eval 'sub CNODEMASK_ATOMSET {
	        my($p, $q) = @_;
    		eval q( &atomicSetUlong(( &cnodemask_t *)($p), $q));
	    }' unless defined(&CNODEMASK_ATOMSET);
	    eval 'sub CNODEMASK_ATOMCLR {
	        my($p, $q) = @_;
    		eval q( &atomicClearUlong(( &cnodemask_t *)($p), $q));
	    }' unless defined(&CNODEMASK_ATOMCLR);
	    eval 'sub CNODEMASK_ATOMSET_MASK {
	        my($__old, $p, $q) = @_;
    		eval q({ ($__old) =  &atomicSetUlong(( &cnodemask_t *)($p), $q); });
	    }' unless defined(&CNODEMASK_ATOMSET_MASK);
	    eval 'sub CNODEMASK_ATOMCLR_MASK {
	        my($__old, $p, $q) = @_;
    		eval q({ ($__old) =  &atomicClearUlong(( &cnodemask_t *)($p),$q); });
	    }' unless defined(&CNODEMASK_ATOMCLR_MASK);
	    eval 'sub CNODEMASK_FROM_NUMNODES {
	        my($n) = @_;
    		eval q(((~( &cnodemask_t)0)>>( &CNODEMASK_BIPW-($n))));
	    }' unless defined(&CNODEMASK_FROM_NUMNODES);
	} else {
	    eval 'sub CNODEMASK_SIZE () {( &MAX_COMPACT_NODES /  &CNODEMASK_BIPW);}' unless defined(&CNODEMASK_SIZE);
	    eval 'sub CNODEMASK_WORD {
	        my($p,$w) = @_;
    		eval q((($w >= 0 && $w <  &CNODEMASK_SIZE) ? ($p). $_bits[($w)] : 0));
	    }' unless defined(&CNODEMASK_WORD);
	    eval 'sub CNODEMASK_SET_WORD {
	        my($p,$w,$val) = @_;
    		eval q({  &if ($w >= 0 && $w <  &CNODEMASK_SIZE) ($p). $_bits[($w)] = $val; });
	    }' unless defined(&CNODEMASK_SET_WORD);
	    eval 'sub CNODEMASK_CLRALL {
	        my($p) = @_;
    		eval q({ ($p). $_bits[0] = 0; ($p). $_bits[1] = 0; });
	    }' unless defined(&CNODEMASK_CLRALL);
	    eval 'sub CNODEMASK_SETALL {
	        my($p) = @_;
    		eval q({ ($p). $_bits[0] = ~(0); ($p). $_bits[1] = ~(0); });
	    }' unless defined(&CNODEMASK_SETALL);
	    eval 'sub CNODEMASK_LSB_ISONE {
	        my($p) = @_;
    		eval q((($p). $_bits[0] & 0x1));
	    }' unless defined(&CNODEMASK_LSB_ISONE);
	    eval 'sub CNODEMASK_SETM {
	        my($p,$q) = @_;
    		eval q({ ($p). $_bits[0] |= (($q). $_bits[0]); ($p). $_bits[1] |= (($q). $_bits[1]); });
	    }' unless defined(&CNODEMASK_SETM);
	    eval 'sub CNODEMASK_CLRM {
	        my($p,$q) = @_;
    		eval q({ ($p). $_bits[0] &= ~(($q). $_bits[0]); ($p). $_bits[1] &= ~(($q). $_bits[1]); });
	    }' unless defined(&CNODEMASK_CLRM);
	    eval 'sub CNODEMASK_ANDM {
	        my($p,$q) = @_;
    		eval q({ ($p). $_bits[0] &= (($q). $_bits[0]); ($p). $_bits[1] &= (($q). $_bits[1]); });
	    }' unless defined(&CNODEMASK_ANDM);
	    eval 'sub CNODEMASK_CPY {
	        my($p, $q) = @_;
    		eval q({ ($p). $_bits[0] = ($q). $_bits[0]; ($p). $_bits[1] = ($q). $_bits[1]; });
	    }' unless defined(&CNODEMASK_CPY);
	    eval 'sub CNODEMASK_CPYNOTM {
	        my($p,$q) = @_;
    		eval q({ ($p). $_bits[0] = ~(($q). $_bits[0]); ($p). $_bits[1] = ~(($q). $_bits[1]); });
	    }' unless defined(&CNODEMASK_CPYNOTM);
	    eval 'sub CNODEMASK_ORNOTM {
	        my($p,$q) = @_;
    		eval q({ ($p). $_bits[0] |= ~(($q). $_bits[0]); ($p). $_bits[1] |= ~(($q). $_bits[1]); });
	    }' unless defined(&CNODEMASK_ORNOTM);
	    eval 'sub CNODEMASK_INDEX {
	        my($bit) = @_;
    		eval q((($bit) >> 6));
	    }' unless defined(&CNODEMASK_INDEX);
	    eval 'sub CNODEMASK_SHFT {
	        my($bit) = @_;
    		eval q((($bit) & 0x3f));
	    }' unless defined(&CNODEMASK_SHFT);
	    eval 'sub CNODEMASK_SETB {
	        my($p, $bit) = @_;
    		eval q(($p). $_bits[ &CNODEMASK_INDEX($bit)] |= (1 <<  &CNODEMASK_SHFT($bit)));
	    }' unless defined(&CNODEMASK_SETB);
	    eval 'sub CNODEMASK_CLRB {
	        my($p, $bit) = @_;
    		eval q(($p). $_bits[ &CNODEMASK_INDEX($bit)] &= ~(1 <<  &CNODEMASK_SHFT($bit)));
	    }' unless defined(&CNODEMASK_CLRB);
	    eval 'sub CNODEMASK_TSTB {
	        my($p, $bit) = @_;
    		eval q((($p). $_bits[ &CNODEMASK_INDEX($bit)] & (1 <<  &CNODEMASK_SHFT($bit))));
	    }' unless defined(&CNODEMASK_TSTB);
	    eval 'sub CNODEMASK_ATOMSET_BIT {
	        my($p, $bit) = @_;
    		eval q(( &atomicSetUlong(($p). $_bits[ &CNODEMASK_INDEX($bit)], (1 <<  &CNODEMASK_SHFT($bit)))););
	    }' unless defined(&CNODEMASK_ATOMSET_BIT);
	    eval 'sub CNODEMASK_ATOMCLR_BIT {
	        my($p, $bit) = @_;
    		eval q(( &atomicClearUlong(($p). $_bits[ &CNODEMASK_INDEX($bit)], (1 <<  &CNODEMASK_SHFT($bit)))););
	    }' unless defined(&CNODEMASK_ATOMCLR_BIT);
	    eval 'sub CNODEMASK_ATOMSET {
	        my($p, $q) = @_;
    		eval q({ \'int\'  &i;  &for ( &i = 0;  &i <  &CNODEMASK_SIZE ;  &i++) {  &atomicSetUlong(($p). $_bits[ &i], ($q). $_bits[ &i]); } });
	    }' unless defined(&CNODEMASK_ATOMSET);
	    eval 'sub CNODEMASK_ATOMCLR {
	        my($p, $q) = @_;
    		eval q({ \'int\'  &i;  &for ( &i = 0;  &i <  &CNODEMASK_SIZE ;  &i++) {  &atomicClearUlong(($p). $_bits[ &i], ($q). $_bits[ &i]); } });
	    }' unless defined(&CNODEMASK_ATOMCLR);
	    eval 'sub CNODEMASK_ATOMSET_MASK {
	        my($__old, $p, $q) = @_;
    		eval q({ ($__old). $_bits[0] =  &atomicSetUlong(($p). $_bits[0], ($q). $_bits[0]); ($__old). $_bits[1] =  &atomicSetUlong(($p). $_bits[1], ($q). $_bits[1]); });
	    }' unless defined(&CNODEMASK_ATOMSET_MASK);
	    eval 'sub CNODEMASK_ATOMCLR_MASK {
	        my($__old, $p, $q) = @_;
    		eval q({ ($__old). $_bits[0] =  &atomicClearUlong(($p). $_bits[0], ($q). $_bits[0]); ($__old). $_bits[1] =  &atomicClearUlong(($p). $_bits[1], ($q). $_bits[1]); });
	    }' unless defined(&CNODEMASK_ATOMCLR_MASK);
	}
    }
}
1;
